Ext.data.JsonP.sol_common_ix_functions_Set({"tagname":"class","name":"sol.common.ix.functions.Set","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.functions.Set.js","href":"sol.common.ix.functions.Set.html#sol-common-ix-functions-Set"}],"eloix":true,"requires":["sol.Logger","sol.common.CounterUtils","sol.common.JsonUtils","sol.common.ObjectFormatter.TemplateSord","sol.common.ObjectUtils","sol.common.RepoUtils","sol.common.SordUtils","sol.common.StringUtils","sol.common.Template","sol.common.TranslateTerms","sol.common.WfUtils","sol.common.ix.ConnectionUtils","sol.common.ix.FunctionBase","sol.common.ix.RfUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.FunctionBase","mixins":[],"uses":[],"members":[{"name":"asAdmin","tagname":"cfg","owner":"sol.common.ix.functions.Set","id":"cfg-asAdmin","meta":{}},{"name":"entries","tagname":"cfg","owner":"sol.common.ix.functions.Set","id":"cfg-entries","meta":{"required":true}},{"name":"flowId","tagname":"cfg","owner":"sol.common.ix.functions.Set","id":"cfg-flowId","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.ix.functions.Set","id":"cfg-objId","meta":{"required":true}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.common.ix.functions.Set","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"timeZone","tagname":"cfg","owner":"sol.common.ix.functions.Set","id":"cfg-timeZone","meta":{}},{"name":"types","tagname":"cfg","owner":"sol.common.ix.functions.Set","id":"cfg-types","meta":{"private":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"emptyFilterTypes","tagname":"property","owner":"sol.common.ix.functions.Set","id":"property-emptyFilterTypes","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.common.ix.FunctionBase","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"applyTemplates","tagname":"method","owner":"sol.common.ix.functions.Set","id":"method-applyTemplates","meta":{"private":true}},{"name":"checkAdminExecutionContext","tagname":"method","owner":"sol.common.ix.functions.Set","id":"method-checkAdminExecutionContext","meta":{"private":true}},{"name":"filterEntry","tagname":"method","owner":"sol.common.ix.functions.Set","id":"method-filterEntry","meta":{"private":true}},{"name":"getValueFromDynKwl","tagname":"method","owner":"sol.common.ix.functions.Set","id":"method-getValueFromDynKwl","meta":{"private":true}},{"name":"getValueFromKwl","tagname":"method","owner":"sol.common.ix.functions.Set","id":"method-getValueFromKwl","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.FunctionBase","id":"method-initialize","meta":{"private":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.functions.Set","id":"method-process","meta":{}},{"name":"processTypeFORMBLOB","tagname":"method","owner":"sol.common.ix.functions.Set","id":"method-processTypeFORMBLOB","meta":{"private":true}},{"name":"processTypeGRP","tagname":"method","owner":"sol.common.ix.functions.Set","id":"method-processTypeGRP","meta":{"private":true}},{"name":"processTypeMAP","tagname":"method","owner":"sol.common.ix.functions.Set","id":"method-processTypeMAP","meta":{"private":true}},{"name":"processTypeMASK","tagname":"method","owner":"sol.common.ix.functions.Set","id":"method-processTypeMASK","meta":{"private":true}},{"name":"processTypeSORD","tagname":"method","owner":"sol.common.ix.functions.Set","id":"method-processTypeSORD","meta":{"private":true}},{"name":"processTypeWF","tagname":"method","owner":"sol.common.ix.functions.Set","id":"method-processTypeWF","meta":{"private":true}},{"name":"processTypeWFMAP","tagname":"method","owner":"sol.common.ix.functions.Set","id":"method-processTypeWFMAP","meta":{"private":true}},{"name":"saveSordValues","tagname":"method","owner":"sol.common.ix.functions.Set","id":"method-saveSordValues","meta":{"private":true}},{"name":"saveWorkflowValues","tagname":"method","owner":"sol.common.ix.functions.Set","id":"method-saveWorkflowValues","meta":{"private":true}},{"name":"RF_sol_function_Set","tagname":"method","owner":"sol.common.ix.functions.Set","id":"static-method-RF_sol_function_Set","meta":{"static":true}},{"name":"onEnterNode","tagname":"method","owner":"sol.common.ix.functions.Set","id":"static-method-onEnterNode","meta":{"static":true}},{"name":"onExitNode","tagname":"method","owner":"sol.common.ix.functions.Set","id":"static-method-onExitNode","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.functions.Set","short_doc":"Edits an existing object by changing the mask or setting different values. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.FunctionBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a><div class='subclass '><strong>sol.common.ix.functions.Set</strong></div></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.Logger' rel='sol.Logger' class='docClass'>sol.Logger</a></div><div class='dependency'><a href='#!/api/sol.common.CounterUtils' rel='sol.common.CounterUtils' class='docClass'>sol.common.CounterUtils</a></div><div class='dependency'><a href='#!/api/sol.common.JsonUtils' rel='sol.common.JsonUtils' class='docClass'>sol.common.JsonUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectFormatter.TemplateSord' rel='sol.common.ObjectFormatter.TemplateSord' class='docClass'>sol.common.ObjectFormatter.TemplateSord</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectUtils' rel='sol.common.ObjectUtils' class='docClass'>sol.common.ObjectUtils</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.StringUtils' rel='sol.common.StringUtils' class='docClass'>sol.common.StringUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><div class='dependency'><a href='#!/api/sol.common.TranslateTerms' rel='sol.common.TranslateTerms' class='docClass'>sol.common.TranslateTerms</a></div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.ConnectionUtils' rel='sol.common.ix.ConnectionUtils' class='docClass'>sol.common.ix.ConnectionUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a></div><div class='dependency'><a href='#!/api/sol.common.ix.RfUtils' rel='sol.common.ix.RfUtils' class='docClass'>sol.common.ix.RfUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set' target='_blank'>sol.common.ix.functions.Set.js</a></div></pre><div class='doc-contents'><p>Edits an existing object by changing the mask or setting different values.</p>\n\n<h1>As workflow node</h1>\n\n<p>ObjId is set based on the element that the workflow is attached to.</p>\n\n<p>The timeZone parameter is currently not supported in conjunction with <code>asAdmin</code>\nbecause we don't want to rewrite the clientInfo of the adminConnection temporarily</p>\n\n<p>Following configuration should be applied to the comments field for a mask and field update:</p>\n\n<h2>Example</h2>\n\n<pre><code>{\n  \"entries\": [{\n    \"type\": \"MASK\",        // changes the mask of the sord, if defined more than once, the first one will be used\n    \"value\": \"Basic Entry\"\n  }, {\n    \"type\": \"SORD\",\n    \"key\": \"name\",\n    \"value\": \"Contract {{sord.objKeys.CONTRACT_NAME}} - {{count 'MY_CONTRACT_COUNTER'}}\",\n    \"useTemplating\": true\n  }, {\n    \"type\": \"GRP\",\n    \"key\": \"CONTRACT_STATUS\",\n    \"value\": \"D\",\n    \"useDynKwl\": true,\n    \"dynKwlCfg\": {\n      \"filterColumn\": 0,\n      \"returnColumn\": 2\n    },\n    \"onlyIfEmpty\": true\n  }, {\n    \"type\": \"MAP\",\n    \"key\": \"USER\",\n    \"value\": \"Bill Gates\",\n  }, {\n    \"type\": \"WFMAP\",\n    \"key\": \"USER\",\n    \"value\": \"Steve Jobs\"\n  }, {\n    \"type\": \"WF\",\n    \"key\": \"STATUS\",\n    \"value\": \"CREATE\"\n  }]\n}\n</code></pre>\n\n<p>Following configuration should be applied to the comments field and will set a value from the fields KWL starting with '3'</p>\n\n<pre><code>{\n  \"entries\": [{\n    \"type\": \"GRP\",\n    \"key\": \"INVOICE_STATUS\",\n    \"value\": \"3\",\n    \"useKwl\": true\n   }]\n}\n</code></pre>\n\n<p>Following configuration will set a field from the fields dynamic KWL staring with 'M' (e.g. M - month) from a localized dynamic KWL</p>\n\n<pre><code>{\n  \"type\": \"GRP\",\n  \"key\": \"REMINDER_PERIOD_UNIT\",\n  \"value\": \"M\",\n  \"useDynKwl\": true,\n  \"dynKwlCfg\": {\n    \"returnColumn\": 2,\n    \"filterColumn\": 0\n  }\n}\n</code></pre>\n\n<h1>As IX function call</h1>\n\n<p>In addition to the workflow node configuration the objId must be passed.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_function_Set\", {\n  objId: \"4711\",\n  asAdmin: true,\n  entries: [{\n    type: \"GRP\",\n    key: \"INVOICE_STATUS\",\n    value: \"3\",\n    useKwl: true\n  }]\n});\n</code></pre>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required config options</h3><div id='cfg-entries' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-cfg-entries' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-cfg-entries' class='name expandable'>entries</a> : Object[]<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<ul><li><span class='pre'>key</span> : String<div class='sub-desc'><p>field key</p>\n</div></li><li><span class='pre'>type</span> : String<div class='sub-desc'><p>the type of the field <a href=\"#!/api/sol.common.ix.functions.Set-cfg-types\" rel=\"sol.common.ix.functions.Set-cfg-types\" class=\"docClass\">types</a></p>\n</div></li><li><span class='pre'>value</span> : String<div class='sub-desc'><p>the value which should be set</p>\n</div></li><li><span class='pre'>useKwl</span> : Boolean<div class='sub-desc'><p>enable keyword lookup for the current value</p>\n</div></li><li><span class='pre'>useDynKwl</span> : Boolean<div class='sub-desc'><p>enable dynamic keyword lookup for the current value</p>\n</div></li><li><span class='pre'>dynKwlCfg</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>onlyIfEmpty</span> : Boolean<div class='sub-desc'><p>the value will only be set when selected field is not empty</p>\n\n<p>Entries that contains the values to set</p>\n</div></li></ul></div></div></div><div id='cfg-objId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-cfg-objId' class='name expandable'>objId</a> : String<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'><p>Object ID</p>\n</div><div class='long'><p>Object ID</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-cfg-objId\" rel=\"sol.common.ix.FunctionBase-cfg-objId\" class=\"docClass\">sol.common.ix.FunctionBase.objId</a></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Optional config options</h3><div id='cfg-asAdmin' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-cfg-asAdmin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-cfg-asAdmin' class='name expandable'>asAdmin</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Execute function in admin context</p>\n</div><div class='long'><p>Execute function in admin context</p>\n</div></div></div><div id='cfg-flowId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-cfg-flowId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-cfg-flowId' class='name expandable'>flowId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Flow ID</p>\n</div><div class='long'><p>Flow ID</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;objId&quot;, &quot;entries&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div><div id='cfg-timeZone' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-cfg-timeZone' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-cfg-timeZone' class='name expandable'>timeZone</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Time zone</p>\n</div><div class='long'><p>Time zone</p>\n</div></div></div><div id='cfg-types' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-cfg-types' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-cfg-types' class='name expandable'>types</a> : Array<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>which are supported ...</div><div class='long'><p>which are supported</p>\n<p>Defaults to: <code>[&quot;MASK&quot;, &quot;SORD&quot;, &quot;GRP&quot;, &quot;MAP&quot;, &quot;FORMBLOB&quot;, &quot;WFMAP&quot;, &quot;WF&quot;]</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-emptyFilterTypes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-property-emptyFilterTypes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-property-emptyFilterTypes' class='name expandable'>emptyFilterTypes</a> : Array<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>[&quot;GRP&quot;, &quot;MAP&quot;]</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the module</p>\n</div><div class='long'><p>The logger for the module</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-applyTemplates' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-method-applyTemplates' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-method-applyTemplates' class='name expandable'>applyTemplates</a>( <span class='pre'>entries</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>entries</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-checkAdminExecutionContext' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-method-checkAdminExecutionContext' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-method-checkAdminExecutionContext' class='name expandable'>checkAdminExecutionContext</a>( <span class='pre'>callback</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>callback</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-filterEntry' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-method-filterEntry' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-method-filterEntry' class='name expandable'>filterEntry</a>( <span class='pre'>sord, entry</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>entry</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getValueFromDynKwl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-method-getValueFromDynKwl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-method-getValueFromDynKwl' class='name expandable'>getValueFromDynKwl</a>( <span class='pre'>maskName, fieldName, valuePrefix, config, foreignKeyConfig</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves a value from the dynamic keyword list of the spezified field. ...</div><div class='long'><p>Retrieves a value from the dynamic keyword list of the spezified field.\nIt checks, if one of the entries in the keyword list starts with the valuePrefix.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>maskName</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>fieldName</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>valuePrefix</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>foreignKeyConfig</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The found item from the keyword list or the valuePrefix, if nothing was found</p>\n</div></li></ul></div></div></div><div id='method-getValueFromKwl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-method-getValueFromKwl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-method-getValueFromKwl' class='name expandable'>getValueFromKwl</a>( <span class='pre'>fieldName, valuePrefix</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves a value from the keyword list of the specified field. ...</div><div class='long'><p>Retrieves a value from the keyword list of the specified field.\nIt checks, if one of the entries in the keyword list starts with the valuePrefix.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>valuePrefix</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The found item from the keyword list or the valuePrefix, if nothing was found</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets a field value ...</div><div class='long'><p>Sets a field value</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-process\" rel=\"sol.common.ix.FunctionBase-method-process\" class=\"docClass\">sol.common.ix.FunctionBase.process</a></p></div></div></div><div id='method-processTypeFORMBLOB' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-method-processTypeFORMBLOB' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-method-processTypeFORMBLOB' class='name expandable'>processTypeFORMBLOB</a>( <span class='pre'>sordMapEntries</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sordMapEntries</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-processTypeGRP' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-method-processTypeGRP' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-method-processTypeGRP' class='name expandable'>processTypeGRP</a>( <span class='pre'>grpEntries</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>grpEntries</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-processTypeMAP' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-method-processTypeMAP' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-method-processTypeMAP' class='name expandable'>processTypeMAP</a>( <span class='pre'>sordMapEntries</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sordMapEntries</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-processTypeMASK' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-method-processTypeMASK' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-method-processTypeMASK' class='name expandable'>processTypeMASK</a>( <span class='pre'>maskEntries</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>maskEntries</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-processTypeSORD' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-method-processTypeSORD' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-method-processTypeSORD' class='name expandable'>processTypeSORD</a>( <span class='pre'>sordEntries</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sordEntries</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-processTypeWF' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-method-processTypeWF' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-method-processTypeWF' class='name expandable'>processTypeWF</a>( <span class='pre'>wfEntries</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>wfEntries</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-processTypeWFMAP' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-method-processTypeWFMAP' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-method-processTypeWFMAP' class='name expandable'>processTypeWFMAP</a>( <span class='pre'>wfMapEntries</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>wfMapEntries</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-saveSordValues' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-method-saveSordValues' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-method-saveSordValues' class='name expandable'>saveSordValues</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-saveWorkflowValues' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-method-saveWorkflowValues' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-method-saveWorkflowValues' class='name expandable'>saveWorkflowValues</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_function_Set' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-static-method-RF_sol_function_Set' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-static-method-RF_sol_function_Set' class='name expandable'>RF_sol_function_Set</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n...</div><div class='long'><p>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_FunctionName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n</div></li></ul></div></div></div><div id='static-method-onEnterNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-static-method-onEnterNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-static-method-onEnterNode' class='name expandable'>onEnterNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called before a workflow node is activated. ...</div><div class='long'><p>This function is called before a workflow node is activated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The activated node ID</p>\n</div></li></ul></div></div></div><div id='static-method-onExitNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Set'>sol.common.ix.functions.Set</span><br/><a href='source/sol.common.ix.functions.Set.html#sol-common-ix-functions-Set-static-method-onExitNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Set-static-method-onExitNode' class='name expandable'>onExitNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called after a workflow node is deactivated. ...</div><div class='long'><p>This function is called after a workflow node is deactivated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The deactivated node ID</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});